# coding: UTF-8

import myvisa

# Timeout(1sec)
DEFAULT_TIMEOUT = 1000

def main():
    #Instantiation of the myvisa class
    visa = myvisa.Myvisa()

    # Get library information
    print(visa.get_lib())

    # Connect
    while True:
        print("VISA Address? (View resources with no input)")
        resource = input()
        # Disp resource list if no input
        if resource == "":
            print("Searching For Resources ...")
            print(visa.get_resources())
        else:
        # Open
            if not visa.open(resource):
                return
            break
    
    # Send and receive commands
    while True:
        print("Please enter the command (Exit with no input)")
        command = input()
        # Exit if no input
        if command == "":
            break

        visa.send_query_msg(command, DEFAULT_TIMEOUT)   # Send and receive
        if "?" in command :                             # If the command contains "?"
            print(visa.msg_buf)                         # Output data

    # Close
    visa.close()

if __name__ == '__main__':
  main()
